class V1::PeopleController < V1::BaseController
  include Authorization

  require_user! only: [:me, :update]

  def show
    render json: person
  end

  def me
    render json: current_person
  end

  def update
    raise Forbidden unless person == current_person || current_person.is_admin?
    person.update!(update_params)
    render json: person
  end

  private

  def person
    @person ||= Person.where('id = ? OR user_id = ?', params[:user_id], params[:user_id]).first_or_create!
  end

  def update_params
    return @update_params if @update_params
    if params[:photo] && ![ActionController::Parameters,
                           ActionDispatch::Http::UploadedFile].include?(params[:photo].class)
      raise ActionController::BadRequest.new('Photo must be an image')
    end
    @update_params = params.permit(:first_name, :last_name, :handle, :photo, :remote_photo_url, social: Sociable::NETWORKS)
  end
end
