class V1::SeasonsController < V1::BaseController
  include Authorization
  require_admin! except: [:index, :show]

  def index
    render json: Season.filter(filter_params)
  end

  def show
    render json: season
  end

  def create
    render json: Season.create!(create_params)
  end

  def update
    season.update!(create_params)
    render json: season
  end

  def destroy
    season.destroy!
    render json: season
  end

  private

  def season
    @season ||= Season.find(params[:id])
  end

  def filter_params
    params.permit(:league_id, :limit, :offset, :ids, ids: [])
  end

  def create_params
    params.permit(:name, :league_id)
  end
end
