class V1::TeamInvitationsController < V1::BaseController
  include Authorization

  require_user! only: [:accept]

  def create
    team = Team.find(invitation_params[:team_id])
    if team.organization.nil?
      raise ActionController::BadRequest.new('Team must be affiliated with an organization')
    elsif !Organization.for_email(invitation_params[:email]).include?(team.organization)
      raise ActionController::BadRequest.new("Invites can only be sent to members of the team's organization")
    end
    require_abilities! :modify_team, for: team
    invitation = TeamInvitation.where(
      team_id: invitation_params[:team_id],
      email:   invitation_params[:email]
    ).first_or_create!
    TeamMailer.invitation(invitation).deliver! if invitation.valid?
    render json: invitation
  end

  def accept
    if team = Team.find_by(join_token: params[:id])
      team.add_member!(current_person)
      render json: team, serializer: V1::TeamPresenter and return
    else
      invitation = TeamInvitation.find_by!(token: params[:id])
      invitation.accept!(current_person)
      invitation.reload
      render json: invitation.team and return
    end

    raise ActiveRecord::RecordNotFound
  end

  def destroy
    invitation = TeamInvitation.find(params[:id])
    require_abilities! :modify_team, for: invitation.team_id
    invitation.destroy!
    render json: invitation
  end

  private

  def invitation_params
    @invitation_params ||= begin
      params.require(:team_id)
      params.require(:email)
      params.permit(:team_id, :email)
    end
  end
end
