class V1::TeamMembersController < V1::BaseController
  include Authorization

  # Non-admins must use team invitations to add users to their teams.
  require_admin! only: [:create]
  require_user! only: [:update, :destroy]

  def index
    members = TeamMember.where(team: team)
    members = members.filter(roles: [params[:role]]) if params[:role]
    render json: members.all, each_serializer: V1::TeamMemberPresenter
  end

  def show
    render json: member, serializer: V1::TeamMemberPresenter
  end

  def create
    person = Person.find_by!(user_id: params.require(:user_id))
    member = team.add_member!(person, params[:roles] || [])
    render json: member, serializer: V1::TeamMemberPresenter
  end

  def update
    # TODO: Do something if last owner/captain removes themselves?
    require_abilities! :modify_team, for: team
    member.update!(roles: params[:roles] || [])
    render json: member, serializer: V1::TeamMemberPresenter
  end

  def destroy
    if member.person.user_id != user_id
      require_abilities! :modify_team, for: team
    end
    member.destroy!
    render json: member, serializer: V1::TeamMemberPresenter
  end

  private

  def team
    @team ||= Team.find(params[:team_id])
  end

  def member
    @member ||= TeamMember.find(params[:member_id])
  end
end
