class V1::TeamUsersController < V1::BaseController
  include Authorization

  # Non-admins must use team invitations to add users to their teams.
  require_admin! only: [:create]
  require_user! only: [:destroy]

  def index
    people = TeamMember.where(team_id: params[:team_id]).map(&:person)
    render json: people, each_serializer: V1::PersonPresenter
  end

  def create
    team.add_member!(person)
    render json: person, serializer: V1::PersonPresenter
  end

  def destroy
    require_abilities! :modify_team, for: params[:team_id] unless user_id == params[:user_id]
    member.destroy!
    render json: person, serializer: V1::PersonPresenter
  end

  private

  def team
    @team ||= Team.find_by!(id: params[:team_id])
  end

  def person
    @person ||= Person.find_by!(user_id: params[:user_id])
  end

  def member
    @member ||= TeamMember.find_by!(team_id: params[:team_id], person: person)
  end
end
