class V1::TournamentEntriesController < V1::BaseController
  include Authorization

  require_user! except: :index

  def index
    entries = TournamentEntry.filter(filter_params)
    render json: entries
  end

  def create
    require_abilities! :modify_team, for: params[:team_id] if params.include?(:team_id)
    entry = TournamentEntry.create!(entry_params)
    render json: entry
  end

  def update
    entry = TournamentEntry.find(params[:id])
    require_abilities! :modify_tournament_entry, for: entry
    entry.update!(entry_params)
    render json: entry
  end

  def destroy
    entry = TournamentEntry.find(params[:id])
    require_abilities! :modify_tournament_entry, for: entry
    entry.destroy!
    render json: entry
  end

  private

  def filter_params
    # if params[:flags].present?
    #   params[:flags] = params[:flags].split(',') if params[:flags].is_a?(String)
    # end

    params[:entrant_id] = params.delete(:team_id) if params.include?(:team_id)
    params.permit(
      :ids,
      :tournament_id,
      :entrant_id,
      :limit,
      :offset,
      flags: [],
      ids: []
    ).reject{|k,v| v.nil?}
  end

  def entry_params
    if params.has_key?(:team_id)
      params[:entrant_id] = params[:team_id]
      params[:entrant_type] = 'Team'
    end

    params.permit(:tournament_id, :entrant_id, :entrant_type, flags: [])
  end
end
