class V1::TournamentStagesController < V1::BaseController
  include Authorization

  require_admin! only: [:update, :create, :destroy]

  def index
    render json: TournamentStage.filter(filter_params)
  end

  def show
    render json: stage
  end

  def create
    render json: tournament.stages.create!(create_params)
  end

  def update
    stage.update!(create_params)
    render json: stage
  end

  def destroy
    render json: stage.destroy!
  end

  private

  def tournament
    @tournament ||= Tournament.find(params.require(:tournament_id))
  end

  def stage
    @stage ||= TournamentStage.find(params.require(:id))
  end

  def filter_params
    return @filter_params if @filter_params
    fparams = params.permit(:tournament_id, :limit, :offset, :ids, :tournament_ids, ids: [], tournament_ids: [])
    if params[:season_id] && !fparams[:tournament_id] && !fparams[:tournament_ids]
      fparams[:tournament_id] = Season.find(params[:season_id]).tournament_ids
    end
    @filter_params = fparams
  end

  def create_params
    @create_params ||= params.permit(:name, :type, :starts_at, :ends_at, :color, :slug)
  end
end
