class V1::TournamentsController < V1::BaseController
  include Authorization

  require_admin! only: [:create, :update, :destroy]

  def index
    tournaments = Tournament.filter(filter_params)
    render json: tournaments
  end

  def show
    render json: tournament
  end

  def update
    tournament.update!(tournament_params)
    render json: tournament
  end

  def create
    render json: Tournament.create!(tournament_params)
  end

  def destroy
    tournament.destroy!
    render json: tournament
  end

  private

  def tournament
    @tournament ||= Tournament.friendly.find(params.require(:id))
  end

  def tournament_params
    return @tparams if @tparams

    [:cover, :logo].each do |param|
      if params[param] && ![ActionController::Parameters,
                            ActionDispatch::Http::UploadedFile].include?(params[param].class)
        raise ActionController::BadRequest.new("#{param.to_s.capitalize} must be an image")
      end
    end

    params[:stages_attributes] = params.delete(:stages) if params.include?(:stages)
    @tparams = params.permit(:name, :slug, :entrants_type, :game_id,
                             :cover, :remote_cover_url, :logo, :remote_logo_url,
                             stages_attributes: [:id, :name, :type, :starts_at, :ends_at, :color])
  end

  def filter_params
    params.permit(:limit, :offset, :ids, game_ids: [], ids: [])
  end
end
