class ApplicationRecord < ActiveRecord::Base
  self.abstract_class = true

  class << self
    def permitted_attributes
      []
    end

    # Applies params as a where chain
    def filter(filter_params)
      offset = filter_params.delete(:offset) || 0
      limit = filter_params.delete(:limit) || 50

      filter_params = translate_filter_params(filter_params)

      array_params = filter_params.select do |attr, value|
        columns_hash[attr.to_s]&.array? && value.is_a?(Array)
      end
      filter_params.reject!{|k,v| array_params.include?(k)}

      array_query = array_params.collect do |k,v|
        "#{k} @> '{#{v.join(',')}}'"
      end.join(' AND ')

      where(filter_params).where(array_query) \
        .limit(limit).offset(offset)
    end

    private

    def translate_filter_params(params)
      Hash[*params.to_h.collect do |attr, value|
        singular = attr.to_s.singularize
        if columns_hash[singular] && !columns_hash[attr.to_s]
          if value.is_a?(String) && value.match(/,/)
            value = value.split(',')
          end
          [singular, value]
        else
          [attr.to_s, value]
        end
      end.flatten(1)]
    end
  end
end
