module Sociable
  extend ActiveSupport::Concern

  NETWORKS = %w[
    facebook
    instagram
    reddit
    snapchat
    tumblr
    twitch
    twitter
    youtube
  ]

  module ClassMethods
    def validate_social(field = :social)
      validate do |record|
        social = record.method(field).call
        unless social.is_a?(Hash)
          errors.add(field, "must be a hash (found #{social.class})")
          next
        end
        bad = social.keys.reject {|network| NETWORKS.include?(network.to_s.downcase)}
        unless bad.empty?
          errors.add(field, "has unrecognized networks: #{bad.map(&:inspect).join(', ')}")
        end
      end
    end
  end
end
