class Event < ApplicationRecord
  include FriendlyId
  friendly_id :title, use: :slugged
  def should_generate_new_friendly_id?
    slug.blank? || (title_changed? && !slug_changed?)
  end

  mount_uploader :logo, EventLogoUploader
  validates_integrity_of :logo
  validates_processing_of :logo
  validates_download_of :logo
end
