class Game < ApplicationRecord
  has_many :teams
  has_many :matches
  has_many :series
  has_many :tournaments
  has_many :articles

  mount_uploader :cover, GameCoverUploader
  validates_integrity_of :cover
  validates_processing_of :cover
  validates_download_of :cover

  def abbr
    read_attribute(:abbr) || name.parameterize
  end
end
