class Organization < ApplicationRecord
  has_and_belongs_to_many :people
  has_many :teams
  scope :for_email, ->(email) { where('? = ANY(email_domains)', email.gsub(/^.*?@/, '')) }
end
