class TeamMember < ApplicationRecord
  belongs_to :team
  belongs_to :person
  attribute :roles, :string, array: true

  def self.can_modify?(person, team)
    return true if person.is_a?(Person) and person.is_admin?
    person_id = person.is_a?(Person) ? person.id : person
    team_id = team.is_a?(Team) ? team.id : team
    self.find_by!(person_id: person_id, team_id: team_id).can_modify? rescue false
  end

  def can_modify?
    !(['owner', 'captain'] & roles).empty?
  end

  def verified
    person.organizations.include?(team.organization)
  end
end
