class TournamentEntry < ApplicationRecord
  belongs_to :tournament
  belongs_to :entrant, polymorphic: true
  validates :tournament, presence: true, with: :validate_tournament
  validates :entrant_type, presence: true, with: :validate_entrant_type

  before_destroy :before_destroy, prepend: true

  private

  def validate_entrant_type
    return if tournament.nil?
    if tournament.entrants_type != entrant_type
      errors.add(:entrant_type, 'is not allowed in Tournament')
    end
  end

  def before_destroy
    if !tournament.registration_open?
      errors.add(:tournament, 'registration is closed')
      raise ActiveRecord::RecordInvalid.new(self)
    end
  end

  def validate_tournament
    return if tournament_id.nil?
    unless tournament.registration_open? || persisted?
      errors.add(:tournament, 'registration is closed')
    end
  end
end
