class V1::BasePresenter < ActiveModel::Serializer
  attribute :id
  class_attribute :controller

  def request
    controller ? controller.request : nil
  end

  class << self
    def serializer_for(model, options)
      "V1::#{model.class.name}Presenter".constantize rescue super
    end

    def image(attr)
      attribute(attr) do
        image = object.send(attr)
        Hash[*[:original, :preview, :thumb].collect do |version|
          uri = version === :original || image.is_svg? ? image.url : image.url(version)
          [version, uri.nil? || uri.to_s.match(/^(http|data)/) ? uri.to_s : [request ? request.base_url : '', uri].join]
        end.flatten]
      end
    end
  end
end
