class V1::PersonPresenter < V1::BasePresenter
  attributes :first_name, :last_name, :handle, :user_id, :social
  attributes :organization_ids, :team_ids
  has_many :organizations
  has_many :teams
  image :photo

  def teams
    object.teams.reject(&:hidden)
  end

  def team_ids
    teams.map(&:id)
  end
end
