class V1::SeriesPresenter < V1::BasePresenter
  attributes :id, :game_id, :tournament_stage_id, :type, :match_ids, :scheduled_at, :settings, :winner_id
  belongs_to :game
  has_many :matches

  # TODO always include these, at any depth
  # `attribute` instead of `has_many` does this and luckily we don't need a
  # presenter here right now.
  attribute :opponents

  def winner_id
    object.winner_id
  end

  def opponents
    object.opponents.sort_by(&:id)
  end

  def type
    object.type || 'Series'
  end

  # Additional fields to take from metadata for single- and double-elimination stages.
  [:winner_to, :loser_to, :round, :ident].each do |attr|
    attribute attr, if: :elimination?
  end
  # attributes :winner_to, :loser_to, :round, :ident, if: :elimination?
  def elimination?; object.stage&.elimination?; end
  def winner_to; object.metadata['winner_to']; end
  def loser_to; object.metadata['loser_to']; end
  def round; object.metadata['round']; end
  def ident; object.metadata['ident']; end
end
