class V1::TeamPresenter < V1::BasePresenter
  # Basic info
  attributes :name, :slug, :description, :social, :website, :join_token, :country, :settings

  # Associations
  attributes :organization_id, :game_id,
             :user_ids, :team_invitation_ids, :tournament_entry_ids
  has_many :team_members
  has_many :users
  has_many :team_invitations
  has_many :tournament_entries

  # Special handling / virtual
  attributes :memberships, :region, :hidden
  image :logo
  image :cover

  def users
    object.people
  end

  def user_ids
    object.team_members.collect {|m| m.person.user_id}
  end
end
