class V1::TournamentPresenter < V1::BasePresenter
  attributes :name, :slug, :description, :tournament_entry_ids, :entrants_type,
    :teams, :team_ids, :state, :stage_ids, :starts_at, :ends_at,
    :game_id, :season_id
  has_many :tournament_entries
  has_many :stages
  has_one :game
  image :cover
  image :logo

  def teams
    object.teams.reject(&:hidden).map {|t| V1::TeamPresenter.new(t)}
  end

  def team_ids
    object.teams.reject(&:hidden).map(&:id)
  end
end
