class V1::TournamentStagePresenter < V1::BasePresenter
  attributes :name, :slug, :type, :tournament_id, :starts_at, :ends_at, :progress, :color
  belongs_to :tournament

  attribute :standings, if: ->{object.is_a?(TournamentStage::RoundRobin)}

  def type
    object.type || 'TournamentStage'
  end

  def progress
    object.progress.round(3)
  end

  def standings
    object.standings
  end
end
