class BaseUploader < CarrierWave::Uploader::Base
  include CarrierWave::MiniMagick

  def store_dir
    "#{model.class.to_s.underscore.pluralize}/#{model.id}/#{mounted_as}"
  end

  def extension_whitelist
    %w(jpg jpeg gif png svg)
  end

  def filename
    "#{Digest::SHA1.hexdigest(original_filename)}.#{file.extension}" if original_filename
  end

  def full_filename(for_file)
    extension = File.extname(for_file)
    base_name = for_file.chomp(extension)
    [base_name, version_name].compact.join('_') + extension
  end

  # CarrierWave's image `version`s only support `:if` (and not `:unless`),
  # and those `:if` conditions must take 1 argument, which is always `self`...
  # even though it's also supposed to be a public method, which has a reference to `self`
  # without needing to have it passed in. But we already knew CarrierWave is braindead.
  def is_svg?(file=self.file)
    file&.extension == 'svg'
  end
  def not_svg?(file=self.file)
    !is_svg?(file)
  end
end
