class TeamLogoUploader < BaseUploader
  version :preview, if: :not_svg? do
    convert :jpg
    process resize_to_fit: [800, 800]

    def full_filename(for_file)
      super.chomp(File.extname(super)) + '.jpg'
    end
  end

  version :thumb, if: :not_svg? do
    convert :png
    process resize_to_fill: [400, 400]

    def full_filename(for_file)
      is_svg? ? super : super.chomp(File.extname(super)) + '.png'
    end
  end
end
