class ColorValidator < ActiveModel::EachValidator
  private

  CSS_COLOR_FORMAT = /(#(?:[0-9a-f]{2}){2,4}|#[0-9a-f]{3}|(?:rgba?|hsla?)\((?:\d+%?(?:deg|rad|grad|turn)?(?:,|\s)+){2,3}[\s\/]*[\d\.]+%?\))/i

  def validate_each(record, attribute, value)
    allow_blank = options.fetch(:allow_blank, false)
    return if allow_blank && value.blank?
    if !CSS_COLOR_FORMAT.match(value)
      record.errors[attribute] << 'is invalid'
    end
  end
end
