CarrierWave.configure do |config|
  case Rails.env
  when 'production' then
    config.fog_provider = 'fog/aws'
    config.fog_credentials = {
      provider: 'AWS',
      use_iam_profile: true,
      region: 'us-west-2'
    }
    # TODO this can't be hardcoded RLCS of course --
    # figure out a way for edge to rewrite URLs to client-specific hostnames?
    config.fog_directory = 'edb-assets.rlcs.gg'
    config.storage = :fog
    config.asset_host = 'https://edb-assets.rlcs.gg'
    break
  when 'staging' then
    config.fog_provider = 'fog/aws'
    config.fog_credentials = {
      provider: 'AWS',
      use_iam_profile: true,
      region: 'us-west-2'
    }
    config.fog_directory = 'edb-assets.staging.esports.internal.justin.tv'
    config.storage = :fog
    config.asset_host = 'https://edb-assets.staging.esports.internal.justin.tv'
    break
  when 'development', 'test' then
    config.storage = :file
    # config.ignore_integrity_errors = false
    # config.ignore_processing_errors = false
    # config.ignore_download_errors = false
    break
  end
end
