# For details on the DSL available within this file, see http://guides.rubyonrails.org/routing.html

Rails.application.routes.draw do
  api_version(:module => "V1", :path => {:value => "v1"}) do
    resources :series
    resources :matches
    resources :games
    resources :user_events
    resources :team_invitations
    resources :people, param: :user_id do
      collection do
        get :me, to: 'people#me'
      end
    end
    resources :teams, param: :team_id do
      member do
        resources :members,
          controller: 'team_members',
          param: :member_id
      end
      member do
        resources :users,
          controller: 'team_users',
          param: :user_id
      end
    end
    resources :team_invitations do
      member do
        patch :accept
      end
    end
    resources :tournaments
    resources :tournament_stages
    resources :tournament_entries
    resources :seasons
    resources :leagues
    resources :articles
    resources :images
    resources :events
  end

  get '*missing', to: 'application#missing'
  post '*missing', to: 'application#missing'
  root to: 'application#health'
end
