class DenormalizeTeamRoles < ActiveRecord::Migration[5.0]
  def up
    rename_table :people_teams, :team_members
    add_column :team_members, :roles, :string, array: true, default: []
    TeamMember.all.select {|m| !m.role_id.nil?}.each do |member|
      role = Role.where(id: member.role_id).first
      member.update(roles: [role.name])
    end
    remove_column :team_members, :role_id
    drop_table :roles
  end

  def down
    # WARNING: A precondition for up() was that each member had exactly one role on a team,
    #          but applying this migration allows for roles to have *multiple* roles;
    #          undoing this migration will force each user to have only one role again.
    create_table "roles", force: :cascade do |t|
      t.string   "name",       null: false
      t.datetime "created_at", null: false
      t.datetime "updated_at", null: false
    end
    add_column :team_members, :role_id, :uuid
    role_ids = {}
    TeamMember.all.select {|m| m.roles.length > 0}.each do |member|
      member.role_id = role_ids.fetch(member.roles[0]) do |r|
        role_ids.store(r, Role.create(name: r).id)
      end
      member.save
    end

    # Cleanup.
    remove_column :team_members, :roles
    rename_table :team_members, :people_teams
  end
end
