class ChangeOpponentIdToUuid < ActiveRecord::Migration[5.0]
  def change
    drop_table :opponents do |t|
      t.uuid    :contest_id
      t.string  :contest_type
      t.uuid    :contender_id
      t.string  :contender_type
      t.uuid    :winner_id
      t.integer :score
      t.timestamps
    end

    create_table :opponents, id: :uuid, force: :cascade do |t|
      t.uuid     :contest_id
      t.string   :contest_type
      t.uuid     :contender_id
      t.string   :contender_type
      t.integer  :score
      t.datetime :created_at, null: false
      t.datetime :updated_at, null: false
      t.uuid     :winner_id
    end

    remove_column :matches, :winner_id, :integer
    add_column :matches, :winner_id, :uuid
  end
end
