class AddScheduledAtToSeries < ActiveRecord::Migration[5.0]
  def up
    add_column :series, :scheduled_at, :datetime
    Series.all.each do |series|
      matches_start = series.matches.map(&:scheduled_at).compact.min
      series.update!(scheduled_at: matches_start || series.created_at)
    end
    change_column_null :series, :scheduled_at, true
  end

  def down
    remove_column :series, :scheduled_at
  end
end
