class MakePersonOrganizationsUnique < ActiveRecord::Migration[5.0]
  def up
    # Buckle up, bitches:
    # The subquery identifies the _first_ row in which a unique (org, person) pair occurs.
    # For each unique pair, the outer query deletes all rows except the first.
    execute <<~EOF
      DELETE FROM organizations_people op1
      USING (
        SELECT person_id, organization_id, MIN(ctid) AS ctid
        FROM organizations_people
        GROUP BY (person_id, organization_id)
        HAVING COUNT(*) > 1
      ) op2
      WHERE op1.person_id = op2.person_id
        AND op1.organization_id = op2.organization_id
        AND op1.ctid <> op2.ctid
    EOF

    remove_index :organizations_people, [:organization_id, :person_id]
    remove_index :organizations_people, [:person_id, :organization_id]
    add_index :organizations_people, [:organization_id, :person_id], unique: true
    add_index :organizations_people, :person_id
  end

  def down
    remove_index :organizations_people, [:organization_id, :person_id]
    remove_index :organizations_people, :person_id
    add_index :organizations_people, [:organization_id, :person_id]
    add_index :organizations_people, [:person_id, :organization_id]
  end
end
