class CreateArticles < ActiveRecord::Migration[5.0]
  def change
    create_table :articles, id: :uuid do |t|
      t.uuid       :author_id, null: false
      t.string     :title, null: false
      t.jsonb      :body, null: false, default: {}
      t.uuid       :league_id
      t.uuid       :game_id
      t.string     :aasm_state, null: false
      t.datetime   :published_at
      t.timestamps
    end
  end
end
