class AddFlagsToArticles < ActiveRecord::Migration[5.0]
  def change
    add_column :articles, :flags, :string, array: true, default: [], null: false
    # No index: Postgres indexes for array columns will index the full array rather than
    # individual elements in it. The manual recommends using a separate table for tags
    # entirely if looking up based on individual array elements is needed often.
    # (Our use case is very straightforward, though, and migrating to that optimization is
    # straightforward and isolated if it does turn out to be necessary later.)
  end
end
