class CreateEvents < ActiveRecord::Migration[5.0]
  def change
    create_table :events, id: :uuid do |t|
      t.string     :title, null: false
      t.string     :slug
      t.jsonb      :description
      t.string     :logo
      t.string     :twitch_url
      t.datetime   :starts_at
      t.timestamps
    end
    add_index :events, :slug, unique: true
  end
end
