class AddSlugsToThings < ActiveRecord::Migration[5.0]
  def change
    add_column :tournaments, :slug, :string
    add_index  :tournaments, :slug, :unique => true
    add_column :tournament_stages, :slug, :string
    # no index for tournament stage slugs; we'll never use these for routing
    add_column :teams, :slug, :string
    add_index  :teams, :slug, :unique => true
  end
end
