# This file is auto-generated from the current state of the database. Instead
# of editing this file, please use the migrations feature of Active Record to
# incrementally modify your database, and then regenerate this schema definition.
#
# Note that this schema.rb definition is the authoritative source for your
# database schema. If you need to create the application database on another
# system, you should be using db:schema:load, not running all the migrations
# from scratch. The latter is a flawed and unsustainable approach (the more migrations
# you'll amass, the slower it'll run and the greater likelihood for issues).
#
# It's strongly recommended that you check this file into your version control system.

ActiveRecord::Schema.define(version: 20170921005056) do

  # These are extensions that must be enabled in order to support this database
  enable_extension "plpgsql"
  enable_extension "uuid-ossp"

  create_table "articles", id: :uuid, default: -> { "uuid_generate_v4()" }, force: :cascade do |t|
    t.uuid     "author_id",                 null: false
    t.string   "title",                     null: false
    t.jsonb    "body",         default: {}, null: false
    t.string   "aasm_state",                null: false
    t.datetime "published_at"
    t.datetime "created_at",                null: false
    t.datetime "updated_at",                null: false
    t.string   "slug"
    t.string   "cover"
    t.string   "parent_id"
    t.string   "parent_type"
    t.string   "flags",        default: [], null: false, array: true
    t.index ["slug"], name: "index_articles_on_slug", unique: true, using: :btree
  end

  create_table "events", id: :uuid, default: -> { "uuid_generate_v4()" }, force: :cascade do |t|
    t.string   "title",       null: false
    t.string   "slug"
    t.jsonb    "description"
    t.string   "logo"
    t.string   "twitch_url"
    t.datetime "starts_at"
    t.datetime "created_at",  null: false
    t.datetime "updated_at",  null: false
    t.index ["slug"], name: "index_events_on_slug", unique: true, using: :btree
  end

  create_table "games", id: :uuid, default: -> { "uuid_generate_v4()" }, force: :cascade do |t|
    t.string   "name",       null: false
    t.string   "abbr"
    t.datetime "created_at", null: false
    t.datetime "updated_at", null: false
    t.string   "cover"
  end

  create_table "images", id: :string, force: :cascade do |t|
    t.string   "image",                   null: false
    t.string   "tags",       default: [],              array: true
    t.jsonb    "metadata",   default: {}
    t.datetime "created_at",              null: false
    t.datetime "updated_at",              null: false
    t.index ["tags"], name: "index_images_on_tags", using: :btree
  end

  create_table "leagues", id: :uuid, default: -> { "uuid_generate_v4()" }, force: :cascade do |t|
    t.string   "name"
    t.datetime "created_at", null: false
    t.datetime "updated_at", null: false
  end

  create_table "match_players", id: :uuid, default: -> { "uuid_generate_v4()" }, force: :cascade do |t|
    t.uuid     "match_id"
    t.uuid     "player_id"
    t.uuid     "player_team_id"
    t.uuid     "player_organization_id"
    t.uuid     "team_id"
    t.datetime "created_at",             null: false
    t.datetime "updated_at",             null: false
  end

  create_table "match_teams", force: :cascade do |t|
    t.uuid "match_id",  null: false
    t.uuid "team_id",   null: false
    t.uuid "winner_id"
  end

  create_table "matches", id: :uuid, default: -> { "uuid_generate_v4()" }, force: :cascade do |t|
    t.uuid     "game_id"
    t.uuid     "series_id"
    t.datetime "created_at",                null: false
    t.datetime "updated_at",                null: false
    t.datetime "scheduled_at"
    t.string   "state",        default: ""
    t.uuid     "winner_id"
    t.jsonb    "metadata",     default: {}
  end

  create_table "opponents", id: :uuid, default: -> { "uuid_generate_v4()" }, force: :cascade do |t|
    t.uuid     "contest_id"
    t.string   "contest_type"
    t.uuid     "contender_id"
    t.string   "contender_type"
    t.integer  "score"
    t.datetime "created_at",                  null: false
    t.datetime "updated_at",                  null: false
    t.uuid     "winner_id"
    t.jsonb    "metadata",       default: {}
  end

  create_table "organizations", id: :uuid, default: -> { "uuid_generate_v4()" }, force: :cascade do |t|
    t.string   "name",                       null: false
    t.datetime "created_at",                 null: false
    t.datetime "updated_at",                 null: false
    t.string   "email_domains", default: [],              array: true
  end

  create_table "organizations_people", force: :cascade do |t|
    t.uuid "organization_id"
    t.uuid "person_id"
    t.uuid "role_id"
    t.index ["organization_id", "person_id"], name: "index_organizations_people_on_organization_id_and_person_id", unique: true, using: :btree
    t.index ["person_id"], name: "index_organizations_people_on_person_id", using: :btree
  end

  create_table "people", id: :uuid, default: -> { "uuid_generate_v4()" }, force: :cascade do |t|
    t.string   "first_name", default: "", null: false
    t.string   "last_name",  default: ""
    t.string   "handle"
    t.datetime "created_at",              null: false
    t.datetime "updated_at",              null: false
    t.uuid     "user_id",                 null: false
    t.jsonb    "metadata",   default: {}
    t.jsonb    "social",     default: {}
    t.string   "photo"
  end

  create_table "seasons", id: :uuid, default: -> { "uuid_generate_v4()" }, force: :cascade do |t|
    t.string   "name"
    t.uuid     "league_id"
    t.datetime "created_at", null: false
    t.datetime "updated_at", null: false
  end

  create_table "series", id: :uuid, default: -> { "uuid_generate_v4()" }, force: :cascade do |t|
    t.uuid     "game_id"
    t.datetime "created_at",                       null: false
    t.datetime "updated_at",                       null: false
    t.string   "type"
    t.jsonb    "settings",            default: {}, null: false
    t.datetime "scheduled_at"
    t.integer  "tournament_stage_id"
    t.jsonb    "metadata",            default: {}
  end

  create_table "team_invitations", force: :cascade do |t|
    t.uuid     "team_id"
    t.string   "token",                      null: false
    t.string   "email"
    t.boolean  "used",       default: false
    t.datetime "created_at",                 null: false
    t.datetime "updated_at",                 null: false
    t.uuid     "user_id"
  end

  create_table "team_members", force: :cascade do |t|
    t.uuid   "team_id"
    t.uuid   "person_id"
    t.string "roles",     default: [], array: true
    t.index ["person_id", "team_id"], name: "index_team_members_on_person_id_and_team_id", unique: true, using: :btree
    t.index ["team_id", "person_id"], name: "index_team_members_on_team_id_and_person_id", using: :btree
  end

  create_table "teams", id: :uuid, default: -> { "uuid_generate_v4()" }, force: :cascade do |t|
    t.string   "name"
    t.uuid     "organization_id"
    t.uuid     "game_id"
    t.datetime "created_at",                   null: false
    t.datetime "updated_at",                   null: false
    t.string   "join_token"
    t.string   "logo"
    t.jsonb    "settings",        default: {}, null: false
    t.jsonb    "metadata",        default: {}
    t.jsonb    "description",     default: {}
    t.jsonb    "social",          default: {}
    t.string   "website"
    t.string   "country"
    t.string   "slug"
    t.string   "cover"
    t.index ["slug"], name: "index_teams_on_slug", unique: true, using: :btree
  end

  create_table "tournament_entries", force: :cascade do |t|
    t.uuid     "tournament_id"
    t.string   "entrant_type"
    t.uuid     "entrant_id"
    t.datetime "created_at",                 null: false
    t.datetime "updated_at",                 null: false
    t.string   "flags",         default: [],              array: true
  end

  create_table "tournament_stages", force: :cascade do |t|
    t.string   "name"
    t.uuid     "tournament_id"
    t.string   "color",         default: "transparent"
    t.datetime "starts_at"
    t.datetime "ends_at"
    t.datetime "created_at",                            null: false
    t.datetime "updated_at",                            null: false
    t.string   "type"
    t.string   "slug"
  end

  create_table "tournaments", id: :uuid, default: -> { "uuid_generate_v4()" }, force: :cascade do |t|
    t.string   "name"
    t.text     "description"
    t.uuid     "season_id"
    t.datetime "created_at",    null: false
    t.datetime "updated_at",    null: false
    t.string   "entrants_type"
    t.string   "aasm_state"
    t.uuid     "game_id"
    t.string   "slug"
    t.string   "cover"
    t.string   "logo"
    t.index ["slug"], name: "index_tournaments_on_slug", unique: true, using: :btree
  end

end
