require 'smashgg'
require 'open-uri'

namespace 'smashgg' do
  desc "Imports a tournament from smash.gg."
  # `name` is smash.gg's ID for the tournament, e.g. "rlcs3"
  # ENV['SMASHGG_LOG'] controls log filename (default "logs/smashgg.log")
  # ENV['SMASHGG_CACHE'] controls cache directory (default "tmp/cache/smashgg/")
  task :import, [:name] => :environment do |t, args|
    raise 'Missing required argument: name' unless args.name
    smash = Smashgg.new
    smash.make_all_tournaments(args.name)

    # Also clear edge's cache if we're not in dev.
    if Rails.env.production? || Rails.env.staging?
      host = Rails.env.production? ? 'api.rlcs.gg' : 'tourney-edge.staging.esports.internal.justin.tv'
      reset_uris = [
        '/cache/clear'
      ]
      reset_uris.each do |uri|
        url = "http://#{host}#{uri}"
        puts "Clearing #{Rails.env} cache: GET #{url}"
        open(url, {
          'Client-ID' => 'bcYXa1F1EZi'
        })
      end
    end
  end
end
