require 'rails_helper'

describe V1::EventsController, type: :controller do
  describe 'filter_params' do
    it 'translates "on" to "from"/"to"' do
      now = Time.now
      controller.params[:on] = now.to_s
      filters = controller.send(:filter_params)
      expect(filters).to_not include(:on)
      expect(filters[:from]).to eq(now.beginning_of_day)
      expect(filters[:to]).to eq(now.end_of_day)
    end
  end
end
