require 'rails_helper'

describe V1::PeopleController, type: :controller do
  describe '#show' do
    it 'should create a new person when it did not find a match, for now' do
      expect{get :show, params: {user_id: SecureRandom.uuid}}.to_not raise_error
    end
  end

  describe '#me' do
    it 'should reply with the person making the request' do
      # Use different UUIDs in the header and in params; `#me` should use the header.
      request.headers['User-ID'] = exp_uuid = SecureRandom.uuid
      get :me, params: {user_id: SecureRandom.uuid}
      expect(JSON.parse(response.body)['user_id']).to eq(exp_uuid)
    end
  end
end
