require 'rails_helper'

describe V1::SeriesController do
  describe 'filter_params' do
    before :all do
      @league = FactoryGirl.create(:league_with_tournaments,
                                   tournament_count: 2,
                                   name: 'A unique tournament name')
      @season = @league.seasons.first
      # Two Tournaments have the same Season, one does not.
      @tournaments_s1 = @season.tournaments
      @tournament_s2 = FactoryGirl.create(:tournament)
    end

    it 'translates tournament_id to a filter on tournament_stage_id' do
      tournament = @tournament_s2
      stage_ids = tournament.stage_ids.sort

      controller.params[:tournament_id] = tournament.id
      fparams = controller.send(:filter_params)

      expect(fparams).to_not include(:tournament_id)
      expect(fparams).to_not include(:tournament_ids)
      expect(fparams[:tournament_stage_id].sort).to eq(stage_ids)
    end

    it 'translates tournament_ids to a filter on tournament_stage_id' do
      tournaments = [@tournaments_s1[0], @tournament_s2]
      stage_ids = tournaments.map(&:stage_ids).flatten.sort

      controller.params[:tournament_ids] = tournaments.map(&:id)
      fparams = controller.send(:filter_params)

      expect(fparams).to_not include(:tournament_id)
      expect(fparams).to_not include(:tournament_ids)
      expect(fparams[:tournament_stage_id].sort).to eq(stage_ids)
    end

    it 'translates season_id to a filter on tournament_stage_id' do
      stage_ids = @tournaments_s1.map(&:stage_ids).flatten.sort

      controller.params[:season_id] = @season.id
      fparams = controller.send(:filter_params)

      [:tournament_id, :tournament_ids, :season_id].each do |param|
        expect(fparams).to_not include(param)
      end
      expect(fparams[:tournament_stage_id].sort).to eq(stage_ids)
    end

    it 'translates league_id to a filter on tournament_stage_id' do
      stage_ids = @league.seasons.map(&:tournaments).flatten.map(&:stage_ids).flatten.sort

      controller.params[:league_id] = @league.id
      fparams = controller.send(:filter_params)

      [:tournament_id, :tournament_ids, :league_id].each do |param|
        expect(fparams).to_not include(param)
      end
      expect(fparams[:tournament_stage_id].sort).to eq(stage_ids)
    end

    it 'translates league_name to a filter on tournament_stage_id' do
      stage_ids = @league.seasons.map(&:tournaments).flatten.map(&:stage_ids).flatten.sort

      controller.params[:league_name] = @league.name
      fparams = controller.send(:filter_params)

      [:tournament_id, :tournament_ids, :league_name].each do |param|
        expect(fparams).to_not include(param)
      end
      expect(fparams[:tournament_stage_id].sort).to eq(stage_ids)
    end
  end
end
