require 'rails_helper'

describe V1::TeamInvitationsController, type: :controller do
  describe '#create' do
    before :all do
      @org = FactoryGirl.create(:organization, email_domains: ['example.com'])
      @team = FactoryGirl.create(:team_with_people, organization: @org)
      @owner = @team.members.detect {|m| m.roles.include?('owner')}.person
    end

    it 'should send an invitation email' do
      expect(TeamMailer).to receive(:invitation)
      request.headers['User-ID'] = @owner.user_id
      begin
        post :create, params: {
          team_id: @team.id,
          email: 'test@example.com'
        }
      rescue NoMethodError
        # discard #deliver! on nil
      end
    end
  end
end
