require 'rails_helper'

describe V1::TeamsController do
  describe '#team_params' do
    it "does not permit :logo if it's a Hash" do
      request.headers['User-ID'] = SecureRandom.uuid
      post :create,
        params: { name: 'test', logo: { i_am: 'a hash' } }
      expect(controller.send(:params)).to include(:logo)
      expect(controller.send(:team_params)).to_not include(:logo)
    end
  end
end
