require "rails_helper"

RSpec.describe ApplicationRecord, type: :model do
  describe '#filter' do
    it 'should produce an array inclusion query when given an array param for an array column' do
      sql = TournamentEntry.filter({ flags: [1,2] }).to_sql
      expect(sql).to match(Regexp.escape("WHERE (flags @> '{1,2}')"))
    end

    it 'should still produce IN () for non-array columns when given an array param' do
      sql = TournamentEntry.filter({ id: [1,2] }).to_sql
      expect(sql).to match(Regexp.escape('WHERE "tournament_entries"."id" IN (1, 2)'))
    end

    it 'should translate a given plural column to singular' do
      sql = TournamentEntry.filter({ ids: [1,2] }).to_sql
      expect(sql).to match(Regexp.escape('WHERE "tournament_entries"."id" IN (1, 2)'))
    end

    it 'should translate a given plural column CSV to array' do
      sql = TournamentEntry.filter({ ids: '1,2' }).to_sql
      expect(sql).to match(Regexp.escape('WHERE "tournament_entries"."id" IN (1, 2)'))
    end

    it 'should follow limits and offsets' do
      sql = TournamentEntry.filter({ limit: 123, offset: 456 }).to_sql
      expect(sql).to match(/LIMIT 123 OFFSET 456$/)
    end
  end
end
