require 'rails_helper'

RSpec.describe Event, type: :model do
  describe 'slug' do
    it 'is automatically generated from the title' do
      event = FactoryGirl.create(:event, slug: nil)
      expect(event.slug).to_not be_blank
    end

    it 'is not overwritten if it already exists' do
      event = FactoryGirl.create(:event, slug: 'foo')
      expect(event.slug).to eq('foo')
    end

    it 'prohibits duplicate slugs' do
      event = FactoryGirl.create(:event)
      expect{ FactoryGirl.create(:event, slug: event.slug) }.to raise_error(ActiveRecord::RecordNotUnique)
    end
  end

  it_behaves_like 'a model with images for', :event, :logo
end
