require 'rails_helper'

RSpec.describe League, type: :model do
  describe '#teams' do
    before :all do
      @league = FactoryGirl.create(:league_with_tournaments,
                                  tournament_count: 2)
    end
  end

  describe '#name' do
    it 'should validate uniqueness' do
      league = FactoryGirl.create(:league)
      expect(League.new(name: league.name)).to be_invalid
    end
  end
end
