require 'rails_helper'

RSpec.describe Match, type: :model do
  describe '#opponents' do
    before :all do
      @match = FactoryGirl.create(:match)
    end

    it 'requires at least two opponents' do
      match = FactoryGirl.build(:match, opponents_count: 0)
      expect(match).to be_invalid
      FactoryGirl.build(:opponent, contest: match)
      expect(match).to be_invalid
      FactoryGirl.build(:opponent, contest: match)
      expect(match).to be_valid
    end
  end

  describe 'state' do
    before :each do
      @match = FactoryGirl.create(:match)
      @o1, @o2 = @match.opponents
    end

    it 'should stay in the initial state until there is disagreement or consensus' do
      @match.determine_winner!
      expect(@match.winner_id).to eq(nil)
      expect(@match.state).to eq('')

      @o1.update!(winner: @o1)
      expect(@match.winner_id).to eq(@o1.id)
      expect(@match.state).to eq('')

      @o2.update!(winner: @o1)
      expect(@match.winner_id).to eq(@o1.id)
      expect(@match.state).to eq('decided')

      @o1.update!(winner: @o2)
      expect(@match.winner_id).to eq(@o1.id)
      expect(@match.state).to eq('contested')
    end

    it 'should stay in locked state forever' do
      @match.state = 'locked'

      @o1.update!(winner: @o1)
      expect(@match.winner_id).to eq(nil)
      expect(@match.state).to eq('locked')

      @o2.update!(winner: @o2)
      expect(@match.winner_id).to eq(nil)
      expect(@match.state).to eq('locked')

      @o1.update!(winner: @o2)
      expect(@match.winner_id).to eq(nil)
      expect(@match.state).to eq('locked')
    end
  end
end
