require 'rails_helper'

RSpec.describe Organization, :type => :model do
  describe '#for_email' do
    it 'should match email_domains for the address domain' do
      org = FactoryGirl.create(:organization)
      org.update_attribute(:email_domains, ['twitch.tv', 'justin.tv'])

      for email in ['marian@twitch.tv', 'marian@justin.tv'] do
        expect(Organization.for_email(email).collect(&:id)).to include(org.id)
      end

      expect(Organization.for_email('marian@microsoft.com').collect(&:id)).to_not include(org.id)
    end
  end

  it 'can have many people' do
    @org = FactoryGirl.create(:organization_with_people, people_count: 2)
    expect(@org.people.count).to eq(2)
  end

  it 'can have many teams' do
    @org = FactoryGirl.create(:organization_with_teams, team_count: 2)
    expect(@org.teams.count).to eq(2)
  end
end
