require 'rails_helper'

RSpec.describe Season, type: :model do
  describe 'validations' do
    before :all do
      @season = FactoryGirl.create(:season_with_tournaments,
                                   tournament_count: 2)
    end

    it 'requires a league' do
      season = FactoryGirl.build(:season)
      expect(season.league).to_not be_nil
      expect(season).to be_valid
      season.league = nil
      expect(season).to_not be_valid
    end
  end
end
