require 'rails_helper'

describe V1::ArticlePresenter do
  describe 'attributes' do
    before :all do
      @article = FactoryGirl.create(:article, parent: FactoryGirl.create(:game))
      @presenter = V1::ArticlePresenter.new(@article)
    end

    it 'should include all specified attributes' do
      attrs = [:id, :author_id, :title, :slug, :body, :state, :cover, :flags,
               :parent_type, :parent_id, :created_at, :updated_at, :published_at]
      expect((@presenter.as_json.keys & attrs).sort).to eq(attrs.sort)
    end
  end

  describe 'flags' do
    it 'should not contain duplicates' do
      article = FactoryGirl.create(:article)
      article.flags = %w{foo bar foo bar baz foo baz foo} # not persisted; duplicates not removed
      presenter = V1::ArticlePresenter.new(article)
      expect(presenter.as_json[:flags].sort).to eq(%w{foo bar baz}.sort)
    end
  end

  describe 'author_id attribute' do
    it 'should not choke if author was deleted' do
      article = FactoryGirl.create(:article)
      article.author.destroy!
      article.reload
      expect(article.author).to be_nil
      presenter = V1::ArticlePresenter.new(article).as_json
      expect(presenter).to include(:author_id)
      expect(presenter[:author_id]).to be_nil
    end
  end
end
