require 'rails_helper'

describe V1::BasePresenter do
  describe 'image' do
    it 'uses the original URL for thumb and preview for SVGs' do
      team = FactoryGirl.create(:team, logo: File.open('test/fixtures/files/test.svg','r'))
      json = V1::TeamPresenter.new(team).as_json[:logo]
      expect(json[:original]).to_not be_blank
      expect(json[:original]).to end_with('.svg')
      expect(json[:thumb]).to eq(json[:original])
      expect(json[:preview]).to eq(json[:original])
    end
  end
end
