require 'rails_helper'

describe V1::EventPresenter do
  before :all do
    @event = FactoryGirl.create(:event)
    @presenter = V1::EventPresenter.new(@event)
  end

  describe 'attributes' do
    it 'should include all specified attributes' do
      attrs = [:id, :title, :slug, :description, :logo, :twitch_url, :starts_at,
               :created_at, :updated_at]
      expect((@presenter.as_json.keys & attrs).sort).to eq(attrs.sort)
    end
  end
end
